require("map/level")
require("map/levels")


local function GetRandomSubstituteList( substitutes, num_choices )	
	local subs = {}
	local list = {}

	for k,v in pairs(substitutes) do 
		list[k] = v.weight
	end

	for i=1,num_choices do
		local choice = weighted_random_choice(list)
		list[choice] = nil
		subs[choice] = substitutes[choice]
	end

	return subs
end

local SUBS_1= {
			["evergreen"] = 		{perstory=0.5, 	pertask=1, 		weight=1},
			["evergreen_short"] = 	{perstory=1, 	pertask=1, 		weight=1},
			["evergreen_normal"] = 	{perstory=1, 	pertask=1, 		weight=1},
			["evergreen_tall"] = 	{perstory=1, 	pertask=1, 		weight=1},
			["sapling"] = 			{perstory=0.6, 	pertask=0.95,	weight=1},
			["beefalo"] = 			{perstory=1, 	pertask=1, 		weight=1},
			["rabbithole"] = 		{perstory=1, 	pertask=1, 		weight=1},
			["rock1"] = 			{perstory=0.3, 	pertask=1, 		weight=1},
			["rock2"] = 			{perstory=0.5, 	pertask=0.8, 	weight=1},
			["grass"] = 			{perstory=0.5, 	pertask=0.9, 	weight=1},
			["flint"] = 			{perstory=0.5, 	pertask=1,		weight=1},
			["spiderden"] =			{perstory=1, 	pertask=1, 		weight=1},
		}

----------------------------------
-- Survival levels
---------------------------------

AddLevel(LEVELTYPE.SURVIVAL, { --Archipelago Survival
		id = "Archipelago",
		name="Archipelago",
		desc="A wormhole centric island survival map",
		overrides = {
			{"islands", 		"always"},	
			{"start_setpeice", 	"DefaultStart"},
			{"season_start",	"summer"},
			{"cave_entrance",	"never"},
		},
		tasks = {
				"Archipelago_Grasslands",
				"Archipelago_Plains",
				"Archipelago_Rocky",
				"Archipelago_Swamp",
				"Archipelago_Chess",
		},
		numoptionaltasks = 2,
		optionaltasks = {
				"Archipelago_WASPS",
				"Archipelago_Graveyard",
				"Archipelago_Houndoris",
				"Archipelago_IslandOfTheTallbirds",
		},
		set_pieces = {
		},
		
		numrandom_set_pieces = 0,
		random_set_pieces = 
		{
		},
		ordered_story_setpieces = {
		},
		required_prefabs = {
		},
	})
AddLevel(LEVELTYPE.SURVIVAL, { --ring survival
		id = "ring",
		name="Ring",
		desc="Generates either a large ring or a double ring",
		background_node_range = {0,1},
		overrides = {
			{"start_node", "Plain"},
			{"start_setpeice", 	"DefaultStart"},
			{"season_start",	"summer"},
			{"cave_entrance",	"never"},
		},
		tasks = {
				"ring1",
		},
		numoptionaltasks = 0,
		optionaltasks = {
				"Archipelago_WASPS",
				"Archipelago_Graveyard",
				"Archipelago_Houndoris",
				"Archipelago_IslandOfTheTallbirds",
		},
		set_pieces = {
		},
		
		numrandom_set_pieces = 0,
		random_set_pieces = 
		{
		},
		ordered_story_setpieces = {
		},
		required_prefabs = {
		},
	})
AddLevel(LEVELTYPE.SURVIVAL, { --The Game Is Afoot
		id="HUB",
		name="Hubville",
		desc="Based on \"The Game Is Afoot\"",
		overrides={
			--{"world_size", 		"medium"},
			{"day",			 	"longdusk"}, 
			
			{"start_setpeice", 	"gameafootstart"},
			{"start_node",		"Clearing"},
					
			{"season", 			"preonlysummer"}, 
			{"spiders",			"often"},

			{"branching",		"default"},
			{"loop",			"never"},
		},
		substitutes = GetRandomSubstituteList(SUBS_1, 3),
	-- Enemies: Lots of hound mounds and maxwell traps everywhere. Frequent hound invasions.
		tasks = {
			"Resource-Rich",
			"Hubville_Spiders",
			"Hubville_Tentacles",
			"Hubville_Tallbirds",
			"Hubville_Chess",
			"Hubville_Pigs",
		},
		numoptionaltasks = 4,
		optionaltasks = {
			"The hunters_deerclops",
			"Trapped Forest hunters",
			"Guarded Wasps and Frogs and bugs",
			"Hard Tentacle-Blocked The Deep Forest",
			"Hounded Greater Plains",
			"Merms ahoy",
		},
		set_pieces = {
			["SimpleBase"] = { tasks={
								"Hubville_Spiders",
								"Hubville_Tentacles",
								"Hubville_Tallbirds",
								"Hubville_Chess",
								"Hubville_Pigs",}},
			["ResurrectionStone"] = { count=2, tasks={
														"Resource-Rich",
														"Hubville_Spiders",
														"Hubville_Tentacles",
														"Hubville_Tallbirds",
														"Hubville_Chess",
														"Hubville_Pigs", 
														"The hunters_deerclops",
														"Trapped Forest hunters",
														"Guarded Wasps and Frogs and bugs",
														"Hard Tentacle-Blocked The Deep Forest",
														"Hounded Greater Plains",
														"Merms ahoy",} },
		},
		ordered_story_setpieces = {
			"TeleportatoRingLayout",
			"TeleportatoBoxLayout",
			"TeleportatoCrankLayout",
			"TeleportatoPotatoLayout",
			"TeleportatoBaseAdventureLayout",
		},
		required_prefabs = {
			"teleportato_ring",  "teleportato_box",  "teleportato_crank", "teleportato_potato", "teleportato_base", "chester_eyebone"
		},
	})
AddLevel(LEVELTYPE.SURVIVAL, { --Biosphere
		id = "biosphere",
		name="Biosphere",
		desc="Each Biome is a circle, connected by a land bridge.",
		background_node_range = {0,0},
		
		
		overrides = {
			{"start_setpeice", 	"DefaultStart"},
			{"start_node", 	"Biosphere_Clearing"},	
			{"season_start",	"summer"},
			{"cave_entrance",	"never"},
			{"world_size",		"biosphere"},
		},
		tasks = {
				"biosphere_start",
				"biosphere_frogsbeesandwalrusesohmy",
				"biosphere_rocky",
				"biosphere_landofthepigs",
				"biosphere_plains",
				"biosphere_lordoftheflies",
		},
		numoptionaltasks = 2,
		optionaltasks = {
				"biosphere_howsaboutanicegameofchess",
				"biosphere_aintnothingbuthounds",
				"biosphere_tallbirds",
				"biosphere_OHGODSPIDERS",
				"biosphere_flowersandkillerbees",
		},
		set_pieces = {
		},
		
		numrandom_set_pieces = 0,
		random_set_pieces = 
		{
		},
		ordered_story_setpieces = {
		},
		required_prefabs = {
		},
	})
AddLevel(LEVELTYPE.SURVIVAL, { --Tiny Island Survival
		id = "tiniest",
		name="Island Survival Challenge",
		desc="A tiny island with just enough to live on.",
		background_node_range = {0,0},
		
		
		overrides = {
			{"start_setpeice", 	"tinystart"},
			{"start_node", 	"tinyrocky"},	
			{"season_start",	"summer"},
			{"cave_entrance",	"never"},
			{"world_size",		"teeny"},
		},
		tasks = {
				"smallmapgrassy",
		},
		numoptionaltasks = 0,
		optionaltasks = {
		},
		set_pieces = {
		},
		
		numrandom_set_pieces = 0,
		random_set_pieces = 
		{
		},
		ordered_story_setpieces = {
		},
		required_prefabs = {
		},
	})
	
	
-- unimplemented maps because they don't work	
-- basically just a reminder of my failures.
	--[[
AddLevel(LEVELTYPE.SURVIVAL, { 
		id = "Nexus",
		name="Nexus",
		desc="Like Archipelago, but together",
		overrides = {
			{"islands", 		"always"},	
			{"start_setpeice", 	"DefaultStart"},
			{"season_start",	"summer"},
			{"cave_entrance",	"never"},
		},
		tasks = {
				"Nexus_Grasslands",
				"Nexus_Plains",
				"Nexus_Rocky",
				"Nexus_Swamp",
				"Nexus_Chess",
		},
		numoptionaltasks = 2,
		optionaltasks = {
				"Nexus_WASPS",
				"Nexus_Graveyard",
				"Nexus_Houndoris",
				"Nexus_IslandOfTheTallbirds",
		},
		set_pieces = {
		},
		
		numrandom_set_pieces = 0,
		random_set_pieces = 
		{
		},
		ordered_story_setpieces = {
		},
		required_prefabs = {
		},
	})

AddLevel(LEVELTYPE.SURVIVAL, {
		id="biochallenge",
		name="Biosphere Challenge Map",
		desc="A much more challenging biosphere map.",
		overrides={
			--{"world_size", 		"medium"},
			{"day",			 	"longdusk"}, 

			{"world_size",		"biosphere"},
			{"branching",		"default"},
			{"loop",			"never"},
		},
		substitutes = GetRandomSubstituteList(SUBS_1, 3),
	-- Enemies: Lots of hound mounds and maxwell traps everywhere. Frequent hound invasions.
		tasks = {
			"biosphere_start_Challenging",
			"biosphere_frogsandwasps_challenging",
			"biosphere_landofthepigs_challenging",
			"biosphere_rocky_challenging",
			"biosphere_insane_challenging",
			"biosphere_marsh_challenging",
		},
		numoptionaltasks = 4,
		optionaltasks = {
			"biosphere_tallbirds_challenging",
			"biosphere_howsaboutanicegameofchess_challenging",
			"biosphere_OHGODSPIDERS_challenging",
		},
		set_pieces = {
			["SimpleBase"] = { tasks={
								"biosphere_start_Challenging",
								"biosphere_frogsandwasps_challenging",
								"biosphere_landofthepigs_challenging",
								"biosphere_rocky_challenging",
								"biosphere_insane_challenging",
								"biosphere_marsh_challenging",
								}},
			["ResurrectionStone"] = { count=2, tasks={
								"biosphere_tallbirds_challenging",
								"biosphere_howsaboutanicegameofchess_challenging",
								"biosphere_OHGODSPIDERS_challenging",
								} },
		},
		ordered_story_setpieces = {
			"TeleportatoRingLayout",
			"TeleportatoBoxLayout",
			"TeleportatoCrankLayout",
			"TeleportatoPotatoLayout",
			"TeleportatoBaseAdventureLayout",
		},
		required_prefabs = {
			"teleportato_ring",  "teleportato_box",  "teleportato_crank", "teleportato_potato", "teleportato_base", "chester_eyebone"
		},
	})

AddLevel(LEVELTYPE.SURVIVAL, {
		id="CAVE_LEVEL_1",
		name="Caves",
		desc="Aboveground caves",
		overrides={
			{"world_size", 		"default"},
			-- {"day", 			"onlynight"}, 
			{"waves", 			"off"},
			{"location",		"cave"},
			{"boons", 			"never"},
			{"poi", 			"never"},
			{"traps", 			"never"},
			{"protected", 		"never"},
			{"start_setpeice", 	"CaveStart"},
			--{"start_node",		"BGSinkholeRoom"},
		},
		tasks={
			"CavesStart",
			"CavesAlternateStart",
			"FungalBatCave",
			"BatCaves",
			"TentacledCave",
			"SingleBatCaveTask",
			"RabbitsAndFungs",
			"FungalPlain",
			"Cavern",
		},
		numoptionaltasks = math.random(2,3),
		optionaltasks = {
			"CaveBase",
			"MushBase",
			"SinkBase",
			"RabbitTown",
			"RedFungalComplex",
			"GreenFungalComplex",
			"BlueFungalComplex",
		},
	})]]

	-- AddLevel(LEVELTYPE.SURVIVAL, { 
	-- 	id="SURVIVAL_CAVEPREVIEW",
	-- 	name=STRINGS.UI.CUSTOMIZATIONSCREEN.PRESETLEVELS[3],
	-- 	desc=STRINGS.UI.CUSTOMIZATIONSCREEN.PRESETLEVELDESC[3],
	-- 	overrides={
	-- 			{"start_setpeice", 	"CaveTestStart"},		
	-- 			{"start_node",		"Clearing"},
	-- 	},
	-- 	tasks = {
	-- 			"Make a pick",
	-- 			"Dig that rock",
	-- 			"Great Plains",
	-- 			"Squeltch",
	-- 			"Beeeees!",
	-- 			"Speak to the king",
	-- 			"Forest hunters",
	-- 	},
	-- 	numoptionaltasks = 4,
	-- 	optionaltasks = {
	-- 			"Befriend the pigs",
	-- 			"For a nice walk",
	-- 			"Kill the spiders",
	-- 			"Killer bees!",
	-- 			"Make a Beehat",
	-- 			"The hunters",
	-- 			"Magic meadow",
	-- 			"Frogs and bugs",
	-- 	},
	-- 	set_pieces = {
	-- 		["ResurrectionStone"] = { count=2, tasks={"Make a pick", "Dig that rock", "Great Plains", "Squeltch", "Beeeees!", "Speak to the king", "Forest hunters" } },
	-- 		["WormholeGrass"] = { count=8, tasks={"Make a pick", "Dig that rock", "Great Plains", "Squeltch", "Beeeees!", "Speak to the king", "Forest hunters", "Befriend the pigs", "For a nice walk", "Kill the spiders", "Killer bees!", "Make a Beehat", "The hunters", "Magic meadow", "Frogs and bugs"} },
	-- 	},
	-- })

	
